<?php

namespace Sendcrux\Models;

use Illuminate\Database\Eloquent\Model as Eloquent;
use GuzzleHttp\Client;

class Connection extends Eloquent
{
    protected $fillable = ['endpoint', 'api_key'];
    public $timestamps = false;
    
    /**
     * Get mail list's fields
     */
    public function getListFields()
    {
        $response = $this->request('GET', 'lists');
        return $response;
    }
    
    /**
     * Get mail list's details
     */
    public function getListDetails($uid)
    {
        $response = $this->request('GET', "lists/{$uid}");
        return $response;
    }
    
    /**
     * Make an HTTP request, embedding the connection's api token
     */
    public function request($method, $action, $params = [])
    {
        $client = new Client(['base_uri' => $this->endpoint]);

        if ($method == 'GET') {
            $response = $this->getClient()->request($method, $action . '?' . http_build_query(array_merge($params, ['api_token' => $this->api_key])));
        } else {
            $response = $this->getClient()->request($method, $action, ['json' => array_merge($params, ['api_token' => $this->api_key])]);
        }

        return json_decode($response->getBody(), true);
    }
    
    /**
     * Get mail list's UID
     */
    public function getListUid()
    {
        return json_decode($this->settings, true)['mail_list_uid'];
    }
    
    /**
     * Get mail list's name
     */
    public function getListName()
    {
        return json_decode($this->settings, true)['mail_list_name'];
    }
    
    /**
     * Get the HTTP client
     */
    private function getClient()
    {
        $client = new Client(['base_uri' => $this->endpoint]);
        return $client;
    }
}
