<?php

namespace Sendcrux\Controllers;

use GuzzleHttp\Psr7\Request;
use Sendcrux\Models\Connection;

class MailListController
{
    /**
     * Show the post for the given id.
     */
    public function connect()
    {
        $conn = Connection::first();
        if (is_null($conn)) {
            $conn = new Connection();
            $conn->save();
        }

        $conn->endpoint = $_POST['sendcrux-endpoint'];
        $conn->api_key = $_POST['sendcrux-api-key'];
        $conn->save();

        $response = $conn->getListFields();
        return json_response([ 'data' => $response, 'status' => 'ok' ]);
    }

    /**
     * Get mail list's details
     */
    public function get($uid)
    {
        $conn = Connection::first();
        $response = $conn->getListDetails($uid);

        $u = get_user_by('ID', 1);

        $response['wpFields'] = \Sendcrux\Library\WpHelper::getUserMetaFields();
        $response['status'] = 'ok';
        return json_response($response);
    }
    
    /**
     * Save connection settings
     */
    public function save()
    {
        $conn = Connection::first();
        $conn->endpoint = $_POST['endpoint'];
        $conn->api_key = $_POST['api_key'];
        $conn->settings = json_encode($_POST['settings']);
        $conn->save();
        return json_response(['status' => 'ok']);
    }
}
