<?php

namespace Sendcrux\Controllers;

use GuzzleHttp\Psr7\Request;
use Sendcrux\Models\Connection;
use Sendcrux\Models\Job;
use Sendcrux\Models\Queue;
use Sendcrux\Library\WpHelper;
use Sendcrux\Library\JobTable;

use Sendcrux\Models\Existingusers;

class JobController
{
    /**
     * Job listing page
     */
    public function index($id)
    {
        // index content
        $table = new JobTable();
        $notices = $table->process_bulk_action();
        $table->prepare_items();
        $lastUpdate = Job::getLastUpdate();

        return view('@Sendcrux/job/index.twig', [
            'paging' => paginate_links(['total' => Job::count(), 'current' => $_GET['page']]),
            'table' => $table,
            'current_page' => $_GET['page'],
            'lastUpdate' => $lastUpdate,
            'notices' => $notices
        ]);
    }

    public static function update_existing()
    {   
        $existing_users = Existingusers::first();
        if (is_null($existing_users)){
            $users = get_users();
            foreach ($users as $user) {
                $job = new Job();
                $job->operation = 'update';
                $job->user_id = $user->data->ID;
                $job->status = 'new';
                $job->save();
            }
        }
        

        $update_existing_users = new Existingusers();
        $update_existing_users->status = 'done';
        $update_existing_users->save();

        // $_SESSION['sendcrux_existing_users'] = "done";
        $connection = Connection::first();
        $existing_users = Existingusers::first();
        $cronjob = WpHelper::cronjob_path();
        return view('@Sendcrux/connection/index.twig', ['connection' => $connection, 'cronjob' => $cronjob,'existing_users' => $existing_users]);
    }
}

